<?php
// lanyard.php - View Counter'lı + Yeni API Uyumlu Versiyon[](http://45.136.6.107:4001/v1/users/)
header('Content-Type: text/html; charset=utf-8');

$page = 'lanyard';

$counterFile = __DIR__ . "/counter_{$page}.txt";
$ipFile = __DIR__ . "/ips_{$page}.txt";

$ip = $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1';
if ($ip === '::1') $ip = '127.0.0.1';

if (!file_exists($counterFile)) {
    file_put_contents($counterFile, '0');
}
if (!file_exists($ipFile)) {
    file_put_contents($ipFile, '');
}

$ipList = file($ipFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) ?: [];

if (!in_array($ip, $ipList, true)) {
    $fp = fopen($ipFile, 'a');
    if (flock($fp, LOCK_EX)) {
        fwrite($fp, $ip . PHP_EOL);
        flock($fp, LOCK_UN);
        fclose($fp);

        $count = (int)file_get_contents($counterFile);
        $count++;
        file_put_contents($counterFile, (string)$count);
    } else {
        fclose($fp);
    }
}

$count = (int)file_get_contents($counterFile);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@zaafiolansaltanatkuramaz • Lanyard</title>
    <link rel="icon" href="#" id="dynamic-favicon">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../../css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">
    <style>
        .view-counter {
            position: fixed !important;
            bottom: 20px !important;
            left: 50% !important;
            transform: translateX(-50%) !important;
            background: rgba(255, 255, 255, 0.08) !important;
            backdrop-filter: blur(10px) !important;
            border: 1px solid rgba(255, 255, 255, 0.1) !important;
            border-radius: 20px !important;
            padding: 8px 16px !important;
            color: white !important;
            font-family: 'Inter', sans-serif !important;
            font-size: 14px !important;
            font-weight: 500 !important;
            display: flex !important;
            align-items: center !important;
            gap: 8px !important;
            z-index: 9999 !important;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3) !important;
            pointer-events: auto !important;
        }
        .view-counter i {
            font-size: 18px;
            text-shadow: 0 0 8px rgba(255, 255, 255, 1);
        }
        .view-counter span {
            text-shadow: 0 0 8px rgba(255, 255, 255, 1);
        }
        .tooltip-inner {
            background-color: rgba(255, 255, 255, 0.08) !important;
            color: #fff !important;
            font-family: 'Inter', sans-serif;
            font-size: 13px;
            padding: 6px 10px;
            border-radius: 8px;
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="header">
            <div class="avatarWrap">
                <img id="avatar" class="avatar" src="" alt="Avatar">
                <img id="avatarDecor" class="avatarDecor" src="" style="display:none;">
                <div id="dot" class="statusDot"></div>
            </div>
            <div class="info">
                <div class="usernameRow">
                    <div id="username" class="username"></div>
                    <div id="guildTag" class="guildTag hide">
                        <img id="guildBadge" class="guildBadge" src="">
                        <span id="guildText"></span>
                    </div>
                    <div id="deviceList" class="deviceList hide"></div>
                </div>
                <div id="custom" class="custom"></div>
                <div id="activity" class="activity"></div>
            </div>
        </div>

        <div id="spotifyWrap" class="spotifyWrap hide">
            <div class="spotify">
                <img id="cover" class="cover" src="" alt="Album Art">
                <div>
                    <div id="track" class="track"></div>
                    <div id="artist" class="artist"></div>
                </div>
            </div>
            <div class="bar">
                <div id="fill" class="fill"></div>
            </div>
            <div class="time">
                <span id="tNow">0:00</span>
                <span id="tEnd">0:00</span>
            </div>
        </div>

        <div id="lyricsWrap" class="lyrics hide">
            <div class="lyricsViewport" id="lyricsViewport">
                <div class="lyricsInner" id="lyricsInner"></div>
            </div>
        </div>
    </div>

    <!-- VIEW COUNTER -->
    <div class="view-counter" data-bs-toggle="tooltip" data-bs-placement="top" title="Views">
        <i class="fa-solid fa-eye"></i>
        <span><?php echo number_format($count); ?></span>
    </div>

    <script>
        const USER_ID = "1183483778056851536";
        const LYRIC_SYNC_OFFSET = -0.25;

        const el = {
            avatar: document.getElementById("avatar"),
            dot: document.getElementById("dot"),
            guildTag: document.getElementById("guildTag"),
            guildBadge: document.getElementById("guildBadge"),
            guildText: document.getElementById("guildText"),
            username: document.getElementById("username"),
            custom: document.getElementById("custom"),
            activity: document.getElementById("activity"),
            spotifyWrap: document.getElementById("spotifyWrap"),
            cover: document.getElementById("cover"),
            track: document.getElementById("track"),
            artist: document.getElementById("artist"),
            fill: document.getElementById("fill"),
            tNow: document.getElementById("tNow"),
            tEnd: document.getElementById("tEnd"),
            lyricsWrap: document.getElementById("lyricsWrap"),
            lyricsViewport: document.getElementById("lyricsViewport"),
            lyricsInner: document.getElementById("lyricsInner"),
            deviceList: document.getElementById("deviceList"),
            avatarDecor: document.getElementById("avatarDecor")
        };

        const statusColor = s => ({ online:"#3ba55c", idle:"#faa61a", dnd:"#ed4245" }[s] || "#555");
        const fmt = s => Math.floor(s / 60) + ":" + String(Math.floor(s % 60)).padStart(2, "0");

        const NEW_API_HTTP = `http://45.136.6.107:4001/v1/users/${USER_ID}`;

        const DEVICE_SVGS = {
            desktop: `<svg aria-label="Desktop" height="17" width="17" viewBox="0 0 24 24"><path d="M4 2.5c-1.103 0-2 .897-2 2v11c0 1.104.897 2 2 2h7v2H7v2h10v-2h-4v-2h7c1.103 0 2-.896 2-2v-11c0-1.103-.897-2-2-2H4Zm16 2v9H4v-9h16Z"/></svg>`,
            mobile: `<svg aria-label="Mobile" height="14" width="14" viewBox="0 0 1000 1500"><path d="M187 0h626c103.277 0 187 83.723 187 187v1126c0 103.277-83.723 187-187 187H187C83.723 1500 0 1416.277 0 1313V187C0 83.723 83.723 0 187 0Zm-62 1000h750V250H125v750Zm375 125c-69.036 0-125 55.964-125 125s55.964 125 125 125 125-55.964 125-125-55.964-125-125-125Z"/></svg>`,
            web: `<svg aria-label="Web" height="17" width="17" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2Zm-1 17.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93Zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0 1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39Z"/></svg>`,
        };

        let spotifyStartMs = 0;
        let spotifyEndMs = 0;
        let progressRAF = 0;
        let lastSpotifyKey = null;
        let lrc = [];
        let lineEls = [];
        let activeIndex = -1;
        let lyricsRAF = 0;

        function updateFavicon(url) {
            const favicon = document.getElementById("dynamic-favicon");
            if (!favicon) return;
            const img = new Image();
            img.crossOrigin = "anonymous";
            img.onload = () => {
                const canvas = document.createElement("canvas");
                canvas.width = canvas.height = 64;
                const ctx = canvas.getContext("2d");
                ctx.beginPath();
                ctx.arc(32, 32, 32, 0, Math.PI * 2);
                ctx.closePath();
                ctx.clip();
                ctx.drawImage(img, 0, 0, 64, 64);
                favicon.href = canvas.toDataURL("image/png");
            };
            img.src = url;
        }

        function stopProgress() { cancelAnimationFrame(progressRAF); progressRAF = 0; }

        function startProgress() {
            stopProgress();
            const loop = () => {
                if (!spotifyStartMs || !spotifyEndMs) return;
                const now = Date.now();
                const cur = Math.min(now, spotifyEndMs);
                const dur = spotifyEndMs - spotifyStartMs;
                const pct = dur > 0 ? ((cur - spotifyStartMs) / dur) * 100 : 0;
                el.fill.style.width = Math.max(0, Math.min(100, pct)).toFixed(2) + "%";
                el.tNow.textContent = fmt((cur - spotifyStartMs) / 1000);
                el.tEnd.textContent = fmt((spotifyEndMs - spotifyStartMs) / 1000);
                progressRAF = requestAnimationFrame(loop);
            };
            progressRAF = requestAnimationFrame(loop);
        }

        async function fetchSyncedLyrics(title, artist) {
            try {
                const q = encodeURIComponent(`${artist} ${title}`);
                const r = await fetch(`https://lrclib.net/api/search?q=${q}`);
                if (r.ok) {
                    const j = await r.json();
                    if (j?.[0]?.syncedLyrics) {
                        console.log("Lyrics lrclib'den alındı");
                        return parseLrc(j[0].syncedLyrics);
                    }
                }
            } catch (e) { console.log("lrclib başarısız"); }

            try {
                const searchQuery = encodeURIComponent(`${artist} ${title}`);
                const searchRes = await fetch(`https://api.textyl.co/api/search?q=${searchQuery}`);
                if (searchRes.ok) {
                    const searchData = await searchRes.json();
                    if (searchData.length > 0) {
                        const lyricsRes = await fetch(`https://api.textyl.co/api/lyrics?id=${searchData[0].id}`);
                        if (lyricsRes.ok) {
                            const lyricsData = await lyricsRes.json();
                            if (lyricsData.synced) {
                                console.log("Lyrics Textyl synced'den alındı");
                                return parseLrc(lyricsData.synced);
                            } else if (lyricsData.plain) {
                                return [{ t: 0, text: lyricsData.plain.replace(/\n/g, " • ") }];
                            }
                        }
                    }
                }
            } catch (e) { console.log("Textyl başarısız"); }

            return [];
        }

        function parseLrc(lrcText) {
            return lrcText.split("\n").map(l => {
                const m = l.match(/\[(\d+):(\d+(?:\.\d+)?)\](.*)/);
                if (!m) return null;
                const t = parseInt(m[1], 10) * 60 + parseFloat(m[2]);
                const text = (m[3] || "").trim();
                if (!text) return null;
                return { t, text };
            }).filter(Boolean);
        }

        function clearLyrics() {
            cancelAnimationFrame(lyricsRAF);
            lrc = []; lineEls = []; activeIndex = -1;
            el.lyricsInner.innerHTML = "";
            el.lyricsWrap.classList.add("hide");
        }

        function buildLyrics() {
            el.lyricsInner.innerHTML = "";
            lineEls = []; activeIndex = -1;
            const frag = document.createDocumentFragment();
            for (const item of lrc) {
                const div = document.createElement("div");
                div.className = "line";
                div.textContent = item.text;
                frag.appendChild(div);
                lineEls.push(div);
            }
            el.lyricsInner.appendChild(frag);
            requestAnimationFrame(() => centerToIndex(0, true));
        }

        function centerToIndex(i, immediate = false) {
            if (!lineEls[i]) return;
            const vpH = el.lyricsViewport.clientHeight;
            const target = lineEls[i];
            const targetTop = target.offsetTop;
            const targetH = target.getBoundingClientRect().height;
            const center = vpH / 2;
            const y = center - (targetTop + targetH / 2);
            if (immediate) {
                el.lyricsInner.style.transition = "none";
                el.lyricsInner.style.transform = `translateY(${y}px)`;
                el.lyricsInner.offsetHeight;
                el.lyricsInner.style.transition = "";
            } else {
                el.lyricsInner.style.transform = `translateY(${y}px)`;
            }
            if (activeIndex !== i) {
                if (lineEls[activeIndex]) lineEls[activeIndex].classList.remove("active", "near");
                if (lineEls[activeIndex - 1]) lineEls[activeIndex - 1].classList.remove("near");
                if (lineEls[activeIndex + 1]) lineEls[activeIndex + 1].classList.remove("near");
                activeIndex = i;
                lineEls[i].classList.add("active");
                if (lineEls[i - 1]) lineEls[i - 1].classList.add("near");
                if (lineEls[i + 1]) lineEls[i + 1].classList.add("near");
            }
        }

        function findLyricIndex(sec) {
            if (!lrc.length) return -1;
            let lo = 0, hi = lrc.length - 1, ans = 0;
            while (lo <= hi) {
                const mid = (lo + hi) >> 1;
                if (lrc[mid].t <= sec) { ans = mid; lo = mid + 1; } else { hi = mid - 1; }
            }
            return ans;
        }

        function startLyricLoop() {
            cancelAnimationFrame(lyricsRAF);
            const loop = () => {
                const sec = (Date.now() - spotifyStartMs) / 1000 + LYRIC_SYNC_OFFSET;
                const idx = findLyricIndex(sec);
                if (idx >= 0 && idx !== activeIndex) centerToIndex(idx);
                lyricsRAF = requestAnimationFrame(loop);
            };
            lyricsRAF = requestAnimationFrame(loop);
        }

        function render(d) {  // d = api.data
            const u = d.discord_user;
            const status = d.discord_status || "offline";

            // Avatar Decoration
            const decorData = u.avatar_decoration_data;
            if (decorData && decorData.asset) {
                el.avatarDecor.src = `https://cdn.discordapp.com/avatar-decoration-presets/${decorData.asset}.png`;
                el.avatarDecor.style.display = "block";
            } else {
                el.avatarDecor.style.display = "none";
            }

            // Username (orijinal kod gibi username gösteriyor)
            el.username.textContent = u.username || "unknown";

            // Title
            if (d.spotify) {
                document.title = `@${u.username} is listening to ${d.spotify.song}`;
            } else {
                document.title = `@${u.username} • ${status}`;
            }

            // Avatar
            const avatarUrl = u.avatar
                ? `https://cdn.discordapp.com/avatars/${u.id}/${u.avatar}.png?size=128`
                : "https://cdn.discordapp.com/embed/avatars/0.png";
            el.avatar.src = avatarUrl;
            el.dot.style.background = statusColor(status);
            updateFavicon(avatarUrl);

            // Guild Tag / Badge
            const pg = u.primary_guild;
            if (pg && pg.identity_enabled && pg.identity_guild_id && pg.badge) {
                if (pg.tag) {
                    el.guildText.textContent = pg.tag.toUpperCase();
                    el.guildText.classList.remove("hide");
                } else {
                    el.guildText.classList.add("hide");
                }
                const badgeBase = `https://cdn.discordapp.com/guild-tag-badges/${pg.identity_guild_id}/${pg.badge}`;
                el.guildBadge.src = `${badgeBase}.webp?size=32`;
                el.guildBadge.onerror = () => {
                    el.guildBadge.onerror = null;
                    el.guildBadge.src = `${badgeBase}.png?size=32`;
                };
                el.guildTag.classList.remove("hide");
            } else {
                el.guildTag.classList.add("hide");
            }

            // Devices
            el.deviceList.innerHTML = "";
            const devices = [
                d.active_on_discord_desktop && "desktop",
                d.active_on_discord_web && "web",
                d.active_on_discord_mobile && "mobile"
            ].filter(Boolean);

            devices.forEach(type => {
                const wrap = document.createElement("span");
                wrap.className = "deviceIcon";
                wrap.innerHTML = DEVICE_SVGS[type];
                wrap.title = type;
                const svg = wrap.querySelector("svg");
                if (svg) svg.style.fill = statusColor(status);
                el.deviceList.appendChild(wrap);
            });
            el.deviceList.classList.toggle("hide", devices.length === 0);

            // Custom Status
            const cs = (d.activities || []).find(a => a.type === 4);
            el.custom.textContent = cs?.state || "";

            // Normal Activity (Spotify hariç)
            const act = (d.activities || []).find(a => a.type !== 4 && a.name !== "Spotify");
            if (act) {
                const label = { 0: "Playing", 1: "Streaming", 2: "Listening to", 3: "Watching", 5: "Competing in" }[act.type] || "";
                el.activity.textContent = label ? `${label} ${act.name}` : act.name;
            } else if (!d.spotify) {
                el.activity.textContent = "Currently doing nothing";
            } else {
                el.activity.textContent = "";
            }

            // Spotify
            if (d.spotify) {
                const sp = d.spotify;
                const key = `${sp.song}||${sp.artist}||${sp.timestamps?.start || 0}||${sp.timestamps?.end || 0}`;
                el.spotifyWrap.classList.remove("hide");
                el.cover.src = sp.album_art_url || "";
                el.track.textContent = sp.song || "";
                el.artist.textContent = sp.artist || "";
                spotifyStartMs = sp.timestamps?.start || 0;
                spotifyEndMs = sp.timestamps?.end || 0;
                startProgress();

                if (key !== lastSpotifyKey) {
                    lastSpotifyKey = key;
                    clearLyrics();
                    fetchSyncedLyrics(sp.song, sp.artist.split(";")[0].trim()).then(lines => {
                        if (!lines.length) return;
                        lrc = lines;
                        el.lyricsWrap.classList.remove("hide");
                        buildLyrics();
                        startLyricLoop();
                    });
                } else {
                    startLyricLoop();
                }
            } else {
                el.spotifyWrap.classList.add("hide");
                stopProgress();
                clearLyrics();
                lastSpotifyKey = null;
                spotifyStartMs = spotifyEndMs = 0;
            }
        }

        async function fetchData() {
            try {
                const r = await fetch(NEW_API_HTTP, { cache: "no-store" });
                if (r.ok) {
                    const j = await r.json();
                    if (j.success && j.data) {
                        render(j.data);
                    }
                }
            } catch (e) {
                console.error("API hatası:", e);
            }
        }

        // İlk yükleme
        fetchData();

        // Polling (WebSocket yoksa 8 saniyede bir yenile)
        setInterval(fetchData, 8000);

        // Mouse tilt effect
        (function () {
            const card = document.querySelector('.card');
            if (!card) return;
            const isTouch = 'ontouchstart' in window || navigator.maxTouchPoints > 0;
            if (isTouch) return;

            card.addEventListener('mousemove', e => {
                const r = card.getBoundingClientRect();
                const x = e.clientX - r.left;
                const y = e.clientY - r.top;
                const rx = ((y - r.height / 2) / (r.height / 2)) * 10;
                const ry = ((x - r.width / 2) / (r.width / 2)) * -10;
                card.style.transition = 'transform 60ms ease-out';
                card.style.transform = `perspective(900px) rotateX(${rx}deg) rotateY(${ry}deg)`;
            });

            card.addEventListener('mouseleave', () => {
                card.style.transition = 'transform 300ms ease';
                card.style.transform = 'perspective(900px) rotateX(0deg) rotateY(0deg)';
            });
        })();

        // Simple tooltip for view counter
        document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach(el => {
            el.addEventListener('mouseenter', () => {
                const title = el.getAttribute('title');
                if (!title) return;
                const tooltip = document.createElement('div');
                tooltip.className = 'tooltip-inner';
                tooltip.textContent = title;
                tooltip.style.position = 'absolute';
                tooltip.style.left = '50%';
                tooltip.style.transform = 'translateX(-50%)';
                tooltip.style.bottom = '100%';
                tooltip.style.marginBottom = '8px';
                tooltip.style.zIndex = '1000';
                el.style.position = 'relative';
                el.appendChild(tooltip);
                el._tooltip = tooltip;
            });
            el.addEventListener('mouseleave', () => {
                if (el._tooltip) {
                    el.removeChild(el._tooltip);
                    el._tooltip = null;
                }
            });
        });
    </script>
</body>
</html>