<?php
// Çalıştırılan dosyanın adını al (örn: @testuser.php → testuser)
$currentFile = basename($_SERVER['SCRIPT_NAME'], '.php');
$page = ltrim($currentFile, '@');

// Sayaç ve IP dosya yolları
$counterFile = __DIR__ . "/counter_{$page}.txt";
$ipFile = __DIR__ . "/ips_{$page}.txt";

// IP adresini al
$ip = $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1';
if ($ip === '::1') $ip = '127.0.0.1';

// Dosyalar yoksa oluştur
if (!file_exists($counterFile)) {
    file_put_contents($counterFile, '0', LOCK_EX);
}
if (!file_exists($ipFile)) {
    file_put_contents($ipFile, '', LOCK_EX);
}

// IP listesini oku
$ipList = file($ipFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) ?: [];

// Eğer IP yoksa sayaç artır
if (!in_array($ip, $ipList, true)) {
    $fp = fopen($ipFile, 'a');
    if (flock($fp, LOCK_EX)) {
        fwrite($fp, $ip . PHP_EOL);
        flock($fp, LOCK_UN);
        fclose($fp);

        $count = (int)file_get_contents($counterFile);
        $count++;
        file_put_contents($counterFile, (string)$count, LOCK_EX);
    } else {
        fclose($fp);
    }
}

// Sayaç değerini oku ve binlik ayraçla yazdır
$count = (int)file_get_contents($counterFile);
echo number_format($count, 0, ',', '.'); // 1000 -> 1.000
?>
