// its fine idm u skidding 

let lrc = [];
let lineEls = [];
let activeIndex = -1;
let lyricsRAF = 0;

async function fetchSyncedLyrics(title, artist) {
    try {
        const q = encodeURIComponent(`${artist} ${title}`);
        const r = await fetch(`https://lrclib.net/api/search?q=${q}`);
        if (!r.ok) return [];
        const j = await r.json();
        if (!j?.[0]?.syncedLyrics) return [];

        return j[0].syncedLyrics
            .split("\n")
            .map(l => {
                const m = l.match(/\[(\d+):(\d+(?:\.\d+)?)\](.*)/);
                if (!m) return null;
                const t = parseInt(m[1], 10) * 60 + parseFloat(m[2]);
                const text = (m[3] || "").trim();
                if (!text) return null;
                return { t, text };
            })
            .filter(Boolean);
    } catch {
        return [];
    }
}

function clearLyrics() {
    cancelAnimationFrame(lyricsRAF);
    lyricsRAF = 0;
    lrc = [];
    lineEls = [];
    activeIndex = -1;
    el.lyricsInner.innerHTML = "";
    el.lyricsWrap.classList.add("hide");
}

function buildLyrics() {
    el.lyricsInner.innerHTML = "";
    lineEls = [];
    activeIndex = -1;

    const frag = document.createDocumentFragment();
    for (const item of lrc) {
        const div = document.createElement("div");
        div.className = "line";
        div.textContent = item.text;
        frag.appendChild(div);
        lineEls.push(div);
    }
    el.lyricsInner.appendChild(frag);

    requestAnimationFrame(() => {
        centerToIndex(0, true);
    });
}

function centerToIndex(i, immediate = false) {
    if (!lineEls[i]) return;

    const vpH = el.lyricsViewport.clientHeight;
    const target = lineEls[i];

    const targetTop = target.offsetTop;
    const targetH = target.getBoundingClientRect().height;
    const center = vpH / 2;

    const y = center - (targetTop + targetH / 2);

    if (immediate) {
        const prev = el.lyricsInner.style.transition;
        el.lyricsInner.style.transition = "none";
        el.lyricsInner.style.transform = `translateY(${y}px)`;
        el.lyricsInner.offsetHeight;
        el.lyricsInner.style.transition =
            prev || "transform .28s cubic-bezier(.22,.61,.36,1)";
    } else {
        el.lyricsInner.style.transform = `translateY(${y}px)`;
    }

    if (activeIndex !== i) {
        if (lineEls[activeIndex]) {
            lineEls[activeIndex].classList.remove("active", "near");
        }
        if (lineEls[activeIndex - 1]) lineEls[activeIndex - 1].classList.remove("near");
        if (lineEls[activeIndex + 1]) lineEls[activeIndex + 1].classList.remove("near");

        activeIndex = i;

        lineEls[i].classList.add("active");
        if (lineEls[i - 1]) lineEls[i - 1].classList.add("near");
        if (lineEls[i + 1]) lineEls[i + 1].classList.add("near");
    }
}

function findLyricIndex(sec) {
    if (!lrc.length) return -1;
    let lo = 0, hi = lrc.length - 1, ans = 0;
    while (lo <= hi) {
        const mid = (lo + hi) >> 1;
        if (lrc[mid].t <= sec) {
            ans = mid;
            lo = mid + 1;
        } else {
            hi = mid - 1;
        }
    }
    return ans;
}

function startLyricLoop() {
    cancelAnimationFrame(lyricsRAF);

    const loop = () => {
        const sec =
            (Date.now() - spotifyStartMs) / 1000 + LYRIC_SYNC_OFFSET;
        const idx = findLyricIndex(sec);
        if (idx >= 0 && idx !== activeIndex) {
            centerToIndex(idx);
        }
        lyricsRAF = requestAnimationFrame(loop);
    };

    lyricsRAF = requestAnimationFrame(loop);
}
