// its fine idm u skidding
const LANYARD_HTTP = "https://api.lanyard.rest";
const LANYARD_WS = "wss://api.lanyard.rest/socket";
const DEVICE_SVGS = {
    desktop: `
<svg aria-label="Desktop" height="17" width="17" viewBox="0 0 24 24">
<path d="M4 2.5c-1.103 0-2 .897-2 2v11c0 1.104.897 2 2 2h7v2H7v2h10v-2h-4v-2h7c1.103 0 2-.896 2-2v-11c0-1.103-.897-2-2-2H4Zm16 2v9H4v-9h16Z"/>
</svg>`,

    mobile: `
<svg aria-label="Mobile" height="14" width="14" viewBox="0 0 1000 1500">
<path d="M187 0h626c103.277 0 187 83.723 187 187v1126c0 103.277-83.723 187-187 187H187C83.723 1500 0 1416.277 0 1313V187C0 83.723 83.723 0 187 0Zm-62 1000h750V250H125v750Zm375 125c-69.036 0-125 55.964-125 125s55.964 125 125 125 125-55.964 125-125-55.964-125-125-125Z"/>
</svg>`,

    web: `
<svg aria-label="Web" height="17" width="17" viewBox="0 0 24 24">
<path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2Zm-1 17.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93Zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0 1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39Z"/>
</svg>`,
};

let spotifyStartMs = 0;
let spotifyEndMs = 0;
let progressRAF = 0;
let lastSpotifyKey = null;
function updateFavicon(url) {
    const favicon = document.getElementById("dynamic-favicon");
    if (!favicon) return;

    const img = new Image();
    img.crossOrigin = "anonymous";

    img.onload = () => {
        const canvas = document.createElement("canvas");
        canvas.width = canvas.height = 64;

        const ctx = canvas.getContext("2d");
        ctx.beginPath();
        ctx.arc(32, 32, 32, 0, Math.PI * 2);
        ctx.closePath();
        ctx.clip();

        ctx.drawImage(img, 0, 0, 64, 64);
        favicon.href = canvas.toDataURL("image/png");
    };

    img.src = url;
}

function stopProgress() {
    cancelAnimationFrame(progressRAF);
    progressRAF = 0;
}

function startProgress() {
    stopProgress();

    const loop = () => {
        if (!spotifyStartMs || !spotifyEndMs) return;

        const now = Date.now();
        const cur = Math.min(now, spotifyEndMs);
        const dur = spotifyEndMs - spotifyStartMs;

        const pct =
            dur > 0 ? ((cur - spotifyStartMs) / dur) * 100 : 0;

        el.fill.style.width =
            Math.max(0, Math.min(100, pct)).toFixed(2) + "%";

        el.tNow.textContent = fmt((cur - spotifyStartMs) / 1000);
        el.tEnd.textContent = fmt((spotifyEndMs - spotifyStartMs) / 1000);

        progressRAF = requestAnimationFrame(loop);
    };

    progressRAF = requestAnimationFrame(loop);
}

function render(d) {
    const u = d.discord_user;

    const username = u?.username || "unknown";
    const status = d.discord_status || "offline";
    const decorImg = document.getElementById("avatarDecor");
    const decorData = d.discord_user?.avatar_decoration_data;
    if (decorData) {
        decorImg.src =
            `https://cdn.discordapp.com/avatar-decoration-presets/${decorData.asset}.png`;
        decorImg.style.display = "block";
    } else {
        decorImg.style.display = "none";
    }
el.username.textContent = username;

if (d.spotify && d.spotify.song) {
    document.title = `@${username} is listening to ${d.spotify.song}`;
} else {
    document.title = `@${username} • ${status}`;
}
    const avatarUrl = u?.avatar
        ? `https://cdn.discordapp.com/avatars/${u.id}/${u.avatar}.png?size=128`
        : "https://cdn.discordapp.com/embed/avatars/0.png";

    el.avatar.src = avatarUrl;
    el.dot.style.background = statusColor(status);
    updateFavicon(avatarUrl);
    const pg = u?.primary_guild || d.primary_guild;

    if (pg && pg.identity_enabled && pg.identity_guild_id && pg.badge) {
        if (pg.tag) {
            el.guildText.textContent = pg.tag.toUpperCase();
            el.guildText.classList.remove("hide");
        } else {
            el.guildText.textContent = "";
            el.guildText.classList.add("hide");
        }

        const badgeBase =
            `https://cdn.discordapp.com/guild-tag-badges/${pg.identity_guild_id}/${pg.badge}`;

        el.guildBadge.src = `${badgeBase}.webp?size=32`;
        el.guildBadge.onerror = () => {
            el.guildBadge.onerror = null;
            el.guildBadge.src = `${badgeBase}.png?size=32`;
        };

        el.guildTag.classList.remove("hide");
    } else {
        el.guildTag.classList.add("hide");
    }
const deviceList = document.getElementById("deviceList");
deviceList.innerHTML = "";

const devices = [
    d.active_on_discord_desktop && "desktop",
    d.active_on_discord_web && "web",
    d.active_on_discord_mobile && "mobile"
].filter(Boolean);

devices.forEach(type => {
    if (!DEVICE_SVGS[type]) return;

    const wrap = document.createElement("span");
    wrap.className = "deviceIcon";
    wrap.innerHTML = DEVICE_SVGS[type];
    wrap.title = type;

    const svg = wrap.querySelector("svg");
    if (svg) svg.style.fill = statusColor(d.discord_status);

    deviceList.appendChild(wrap);
});

deviceList.classList.toggle("hide", devices.length === 0);


    const cs = (d.activities || []).find(a => a && a.type === 4);
    el.custom.textContent = cs?.state || "";

    const act = (d.activities || []).find(a => a && a.type !== 4 && a.name);

    if (act) {
        const label =
            { 0: "Playing", 1: "Streaming", 2: "Listening to", 3: "Watching", 5: "Competing in" }[act.type] || "";
        el.activity.textContent = label
            ? `${label} ${act.name}`
            : act.name;
    } else if (!d.spotify) {
        el.activity.textContent = "Currently doing nothing";
    } else {
        el.activity.textContent = "";
    }

    if (d.spotify) {
        const sp = d.spotify;
        const key =
            `${sp.song}||${sp.artist}||${sp.timestamps?.start || 0}||${sp.timestamps?.end || 0}`;

        el.spotifyWrap.classList.remove("hide");
        el.cover.src = sp.album_art_url || "";
        el.track.textContent = sp.song || "";
        el.artist.textContent = sp.artist || "";

        spotifyStartMs = sp.timestamps?.start || 0;
        spotifyEndMs = sp.timestamps?.end || 0;

        startProgress();

        if (key !== lastSpotifyKey) {
            lastSpotifyKey = key;
            clearLyrics();

            fetchSyncedLyrics(
                sp.song,
                (sp.artist || "").split(",")[0] || ""
            ).then(lines => {
                if (!lines.length) return;
                lrc = lines;
                el.lyricsWrap.classList.remove("hide");
                buildLyrics();
                startLyricLoop();
            });
        } else {
            startLyricLoop();
        }
    } else {
        el.spotifyWrap.classList.add("hide");
        stopProgress();
        clearLyrics();
        lastSpotifyKey = null;
        spotifyStartMs = 0;
        spotifyEndMs = 0;
    }
}

let heartbeat;
function connect() {
    const ws = new WebSocket(LANYARD_WS);
    ws.onopen = () => {
        ws.send(JSON.stringify({
            op: 2,
            d: { subscribe_to_id: USER_ID }
        }));
        heartbeat = setInterval(() => {
            ws.send(JSON.stringify({ op: 3 }));
        }, 30000);
    };
    ws.onmessage = e => {
        let m;
        try {
            m = JSON.parse(e.data);
        } catch {
            return;
        }

        if (m.t === "INIT_STATE" || m.t === "PRESENCE_UPDATE") {
            if (m.d) render(m.d);
        }
    };
    ws.onclose = () => {
        clearInterval(heartbeat);
        setTimeout(connect, 1500);
    };
    ws.onerror = () => {
        ws.close();
    };
}
fetch(`${LANYARD_HTTP}/v1/users/${USER_ID}`, { cache: "no-store" })
    .then(r => r.json())
    .then(j => j?.data && render(j.data))
    .catch(() => {});

connect();







